# 가장 긴 증가하는 부분수열(Longest Increasing Subsequence; LIS)

이 문제는 dp 를 사용하는 감을 익히기도 좋으면서 난이도가 높지 않아서 이번 주 스터디 메인 문제로 선정했다.

LIS 를 어떻게 구할 수 있을까?

뭐든지 모르겠다면 가장 처음에는 무식한 방법으로 도전하는 게 (보통) 맞다.

음.

이러면 어떨까? 🧐

1. 모든 부분 수열을 다 구한다.

2. 그 중에서 증가하는 가장 긴 부분 수열의 길이를 반환한다.

조금 더 디테일하게 따져보자.

일단 길이가 n 인 수열이 있다고 치자.

이 수열에 대한 모든 부분 수열은 어떻게 구할까?

각각의 수열의 원소를 택하느냐 마느냐의 문제라고 생각할 수 있다.

2 진법으로 생각하는 건 어떨까?

10 20 30 10 20 과 같은 수열이 있다면

0 0 0 1 1 은 {10, 20} 이고

1 0 1 0 1 은 {10, 30, 20} 이다.

위 수열은 2^5 개의 부분 수열을 가질 수 있다. (각각의 자릿수의 원소를 선택 하느냐 마느냐에 따라서 결정되기 때문이다.)

그러면

길이가 n 인 수열의 부분 수열은 2^n 개 임을 알 수 있다.

그러므로

부분 수열을 구하는 것은 O(2^n) 일 것이다.

부분 수열이 하나 주어지면, 그것이 증가하는 지 판단하는 것은 그 수열을 1 회 순회하는 것 만으로 충분하다.

모든 부분 수열에 대해서 증가하는 지 판단해야 하므로

최종적으로는 O(n*2^n) 정도의 시간 복잡도가 나올 것이다.

이 문제에서는 n 은 1000 이므로

O(1000 x 2^1000) 은

![image](https://github.com/Study-Anything/Algorithm/assets/96612168/92d0bfd3-58b6-47b1-a406-45c2e7b93195)

사실 계산해보지 않아도... 직관적으로 알 수 있는 너무 큰 수 이다. 🫠

---

그러면 이를 최적화해야 할 텐데, 어떻게 해야할까?

사실 스스로 아이디어를 떠올리는 것은 많이 힘들 것 같다.

dp[x] 를 배열의 x 번째 원소까지 탐색했을 때의 LIS 라고 정의하고

한 번 더 고민해보면, 의외로 쉽게 답을 도출할 수 있을 것이다.



사실, 조금 더 힌트를 주고 싶은데

스포일러를 하지 않는 선에서 글로 설명하는 게 조금 난감한 것 같다..

일단 dp[x] 를 x 번쨰 원소를 마지막 원소로 가지는 lis의 길이라고 정의한 다음

10 20 10 30 50 에 대해서 dp table 을 손으로 채워가면서

규칙성(점화식)을 찾아보는 것이 좋겠다.

잘 모르겠다면, 스터디 시간에 설명할 예정이니 계속 고민해보도록 하자.

참고로,

dp 를 사용한 방법(O(N^2))을 한 번 더 최적화한 풀이(O(nlogn))가 존재한다. 

이는 다음 스터디 때 시간이 남으면 설명해보도록 하겠습니다. 🔥
